%	Example 9.21 Linear-phase IIR filter
	clear all
	close all
	N = 11; 
	wcT = 0.2*pi;
	wsT = 0.4*pi;
	Amax = 0.0033074;	% pi/180 rad	
	Amin = 40;
	[G, Z, P] = L_PHASE_IIR(wcT, wsT, Amax, Amin, N)
	
	figure(1)
	PLOT_PZ_Z(Z, P)
	zoom on
	figure(2)
	subplot('position', [0.1 0.4 0.88 0.5]);
	wT = linspace(0, pi, 1000);	
	Att = PZ_2_ATT_Z(G, Z, P, wT);
	Taug = PZ_2_TG_Z(G, Z, P, wT);
	axis_Amax = 60;	axis_Tg_max = 15;
	PLOT_ATT_TG_Z(Att, Taug, wT, axis_Amax, axis_Tg_max)
	fs = 16; % Font size
	lw = 1; % Linewidth
	fn = 'times'; % Font
	text(0.3, 10.5,'{\it\tau_g}({\ite^j^\omega^T })','FontName',fn,'FontSize',fs);	
	text(1.5, 8,'{\itA}({\ite^j^\omega^T})','FontName',fn,'FontSize',fs);
	
